<?xml version='1.0'?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>

<!--	movieArt template. Deals with cover art.
-->
<xsl:template name="movieArt">
	<xsl:param name="height" select="''"/>
	<xsl:param name="width" select="''"/>
	<xsl:param name="altText" select="''"/>
	<xsl:param name="artRoot" select="'default'"/>
	<xsl:variable name="artFile" select="RELEASES/RELEASES_ITEM/COVERARTNAME"/>
	<xsl:choose>
	<xsl:when test="string-length($artFile)  &gt; 0">
			<xsl:variable name="movieArtPath" select="concat($movieArtRoot, '/', substring($artFile, 5, 2), '/', $artFile, '.jpg')"/>
			<img border="0" hspace="3" vspace="3">
				<xsl:attribute name="alt"><xsl:value-of select="$altText"/></xsl:attribute>
				<xsl:attribute name="src"><xsl:value-of select="$movieArtPath"/></xsl:attribute>
				<xsl:if test="string-length($height) &gt; 0">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="string-length($width) &gt; 0">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
			</img>
		</xsl:when>
		<xsl:otherwise><img src="images/placeholder3.gif" height="100"/></xsl:otherwise>
	</xsl:choose>

</xsl:template>

<xsl:template name="movieLongName">
	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) <xsl:value-of select="RELEASES/RELEASES_ITEM/RATINGTEXT"/>
</xsl:template>

<!-- 	Template to print out a list of contributors (Producers, Directors, Star, etc.)
-->
<xsl:template match="CONTRIBUTORS_ITEM" mode="contributorsList">
	<xsl:value-of select="FIRSTNAME"/>&#160;<xsl:value-of select="LASTNAME"/><xsl:if test="position() &lt; last()">,</xsl:if>&#160;
</xsl:template>

<!--	Templates to list movie producer(s). Uses contributorsList template.
-->
<xsl:template match="CONTRIBUTORS" mode="movieProducer">
	<xsl:variable name="producers" select="CONTRIBUTORS_ITEM[JOBNAME='Producer']"/>
	<xsl:apply-templates select="$producers" mode="contributorsList"/>
</xsl:template>



<!--	Template to list movie director(s). Uses contributorsList template.
-->

<xsl:template match="CONTRIBUTORS" mode="movieDirector">
	<xsl:variable name="directors" select="CONTRIBUTORS_ITEM[JOBNAME='Director']"/>
	<xsl:apply-templates select="$directors" mode="contributorsList"/>
</xsl:template>

<!--	Template to list movie star(s). Uses contributorsList template.
-->
<xsl:template match="CONTRIBUTORS" mode="movieStar">
	<xsl:variable name="stars" select="CONTRIBUTORS_ITEM[JOBNAME='Star']"/>
	<xsl:apply-templates select="$stars" mode="contributorsList"/>
</xsl:template>

<!--	Template to get the movie description. Attempts to get the Synopsis note, if
		it exists. Defaults to the VideoLog template.
-->

<xsl:template match="NOTES" mode="movieDescription">
	<xsl:variable name="synopsis" select="NOTES_ITEM[NOTETYPEDESCR='Synopsis']"/>
	<xsl:choose>
		<xsl:when test="count($synopsis) &gt; 0">
			<xsl:value-of select="$synopsis/NOTETEXT"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="videologdesc" select="NOTES_ITEM[starts-with(NOTETYPEDESCR, 'VideoLog')]"/>
			<xsl:value-of select="$videologdesc/NOTETEXT"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>
